//*****************************************************************************
//
//! @file am_devices_mspi_rm69330.h
//!
//! @brief MSPI Display driver.
//
//*****************************************************************************

//*****************************************************************************
//
// ${copyright}
//
// This is part of revision ${version} of the AmbiqSuite Development Package.
//
//*****************************************************************************

#ifndef AM_DEVICES_MSPI_RM69330_H
#define AM_DEVICES_MSPI_RM69330_H

#ifdef __cplusplus
extern "C"
{
#endif


#include "am_mcu_apollo.h"
#include "am_util_stdio.h"
#include "am_bsp.h"
#include "am_util_delay.h"

//*****************************************************************************
//
// Global definitions for DISPLAY commands
//
//*****************************************************************************
#define AM_DEVICES_MSPI_RM69330_CMD_WRITE           0x02
#define AM_DEVICES_MSPI_RM69330_PIXEL_WRITE_ADDR1   0x32    // address on single line
#define AM_DEVICES_MSPI_RM69330_PIXEL_WRITE_ADDR4   0x12    // address on quad interface
#define AM_DEVICES_MSPI_RM69330_CMD_READ            0x03

#define AM_DEVICES_MSPI_RM69330_PAGE_PROGRAM        0x02
#define AM_DEVICES_MSPI_RM69330_READ                0x03
#define AM_DEVICES_MSPI_RM69330_WRITE_DISABLE       0x04
#define AM_DEVICES_MSPI_RM69330_READ_STATUS         0x05
#define AM_DEVICES_MSPI_RM69330_WRITE_ENABLE        0x06
#define AM_DEVICES_MSPI_RM69330_FAST_READ           0x0B
#define AM_DEVICES_MSPI_RM69330_SLEEP_IN            0x10
#define AM_DEVICES_MSPI_RM69330_SLEEP_OUT           0x11
#define AM_DEVICES_MSPI_RM69330_NORMAL_MODE_ON      0x13
#define AM_DEVICES_MSPI_RM69330_INVERSION_OFF       0x20
#define AM_DEVICES_MSPI_RM69330_DISPLAY_OFF         0x28
#define AM_DEVICES_MSPI_RM69330_DISPLAY_ON          0x29
#define AM_DEVICES_MSPI_RM69330_SET_COLUMN          0x2A
#define AM_DEVICES_MSPI_RM69330_SET_ROW             0x2B
#define AM_DEVICES_MSPI_RM69330_MEM_WRITE           0x2C
#define AM_DEVICES_MSPI_RM69330_TE_LINE_OFF         0x34
#define AM_DEVICES_MSPI_RM69330_TE_LINE_ON          0x35
#define AM_DEVICES_MSPI_RM69330_SCAN_DIRECTION      0x36
#define AM_DEVICES_MSPI_RM69330_IDLE_MODE_OFF       0x38
#define AM_DEVICES_MSPI_RM69330_PIXEL_FORMAT        0x3A
#define AM_DEVICES_MSPI_RM69330_DUAL_READ           0x3B
#define AM_DEVICES_MSPI_RM69330_MEM_WRITE_CONTINUE  0x3C
#define AM_DEVICES_MSPI_RM69330_SET_TEAR_SCANLINE   0x44
#define AM_DEVICES_MSPI_RM69330_WRITE_DISPLAY_BRIGHTNESS  0x51
#define AM_DEVICES_MSPI_RM69330_WRITE_ENHVOL_CFG    0x61
#define AM_DEVICES_MSPI_RM69330_RESET_ENABLE        0x66
#define AM_DEVICES_MSPI_RM69330_QUAD_READ           0x6B
#define AM_DEVICES_MSPI_RM69330_WRITE_VOL_CFG       0x81
#define AM_DEVICES_MSPI_RM69330_RESET_MEMORY        0x99
#define AM_DEVICES_MSPI_RM69330_READ_ID             0x9F
#define AM_DEVICES_MSPI_RM69330_ENTER_4B            0xB7
#define AM_DEVICES_MSPI_RM69330_SET_DSPI_MODE       0xC4
#define AM_DEVICES_MSPI_RM69330_BULK_ERASE          0xC7
#define AM_DEVICES_MSPI_RM69330_SECTOR_ERASE        0xD8
#define AM_DEVICES_MSPI_RM69330_EXIT_4B             0xE9
#define AM_DEVICES_MSPI_RM69330_QUAD_IO_READ        0xEB
#define AM_DEVICES_MSPI_RM69330_READ_QUAD_4B        0xEC
#define AM_DEVICES_MSPI_RM69330_CMD_MODE            0xFE

//*****************************************************************************
//
// Global type definitions.
//
//*****************************************************************************
typedef enum
{
    AM_DEVICES_MSPI_RM69330_STATUS_SUCCESS,
    AM_DEVICES_MSPI_RM69330_STATUS_ERROR
} am_devices_mspi_rm69330_status_t;

#define AM_DEVICES_MSPI_RM69330_SPI_WRAM            0x80
#define AM_DEVICES_MSPI_RM69330_DSPI_WRAM           0x81

#define AM_DEVICES_MSPI_RM69330_COLOR_MODE_8BIT     0x72
#define AM_DEVICES_MSPI_RM69330_COLOR_MODE_3BIT     0x71
#define AM_DEVICES_MSPI_RM69330_COLOR_MODE_16BIT    0x75
#define AM_DEVICES_MSPI_RM69330_COLOR_MODE_24BIT    0x77

#define AM_DEVICES_MSPI_RM69330_SCAN_MODE_0         0x40
#define AM_DEVICES_MSPI_RM69330_SCAN_MODE_90        0x70
#define AM_DEVICES_MSPI_RM69330_SCAN_MODE_180       0x10
#define AM_DEVICES_MSPI_RM69330_SCAN_MODE_270       0x00

typedef struct
{
    uint8_t bus_mode;
    uint8_t color_mode;
    uint8_t scan_mode;

    uint32_t max_row;
    uint32_t max_col;
    uint32_t row_offset;
    uint32_t col_offset;
} am_devices_mspi_rm69330_graphic_conf_t;

typedef struct
{
    am_hal_mspi_device_e eDeviceConfig;
    am_hal_mspi_clock_e eClockFreq;
    am_hal_mspi_xipmixed_mode_e eMixedMode;
    uint32_t *pNBTxnBuf;
    uint32_t ui32NBTxnBufLength;
} am_devices_mspi_rm69330_config_t;

#define AM_DEVICES_MSPI_RM69330_MAX_DEVICE_NUM    1

//*****************************************************************************
//
// External function definitions.
//
//*****************************************************************************
extern uint32_t am_devices_mspi_rm69330_init(uint32_t ui32Module, am_devices_mspi_rm69330_config_t *pDevCfg, void **ppHandle, void **ppMspiHandle);
extern uint32_t am_devices_mspi_rm69330_term(void *pHandle);
extern uint32_t am_devices_mspi_rm69330_display_off(void *pHandle);
extern uint32_t am_devices_mspi_rm69330_display_on(void *pHandle);

extern uint32_t am_devices_mspi_rm69330_nonblocking_write(void *pHandle, const uint8_t *pui8TxBuffer,
                                                                        uint32_t ui32NumBytes,
                                                                        bool bWaitForCompletion);
extern uint32_t am_devices_mspi_rm69330_nonblocking_write_adv(void *pHandle,
                                                                         uint8_t *pui8TxBuffer,
                                                                         uint32_t ui32NumBytes,
                                                                         uint32_t ui32PauseCondition,
                                                                         uint32_t ui32StatusSetClr,
                                                                         am_hal_mspi_callback_t pfnCallback,
                                                                         void *pCallbackCtxt);
extern uint32_t am_devices_mspi_rm69330_row_col_reset(void *pHandle);
extern uint32_t am_devices_mspi_rm69330_set_transfer_window(void *pHandle, uint16_t col_start, uint16_t col_end,
                                            uint16_t row_start, uint16_t row_end);

#ifdef __cplusplus
}
#endif

#endif // AM_DEVICES_MSPI_RM69330_H

