@echo off
setlocal
set N=0

REM Add timestamp
set timestamp=%DATE:/=-%_%TIME::=-%
set timestamp=%timestamp: =%
set LOGFILE=am_a3bp_evb_audio_%timestamp%.log
REM @echo on

echo Apollo3 Blue Plus Audio Record Tool - Voice-On-SPOT, Ambiq Micro
:input

jlink -CommanderScript record_load_firmware_ap3pb.txt

:loop
set /a N+=1
set FILENAME=recorded_data_%timestamp%
set FILENAME_OUT=decoded_rtt_data_%timestamp%
if exist %FILENAME% goto :loop

echo -- Firmware loaded.
echo -- Waiting for board to boot.....

REM Added C:\Users\<user_name>\Anaconda3\Scripts to system env variable PATH
call activate.bat
python ftdi_bin_decoder.py logger -c -o %FILENAME%

opus_demo_tools_0.2.exe -d 16000 1 %FILENAME%_opus %FILENAME_OUT%

python bin_to_wav.py mono -i %FILENAME%_pcm -o raw -s 0 -r 16000
python bin_to_wav.py mono -i %FILENAME_OUT% -o decoded -s 0 -r 16000
pause
endlocal